# Install Follow Up Tracking 
# Copyright 2004, 2006 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041026 - first draft of program based on Install Earned Value Tracking
# 041030 - moved ProjectID and Project/Name to front of list
# 041229 - added "Who" column
# 060204 - Brian - allow follow up item's project id to be changed
# 060820 - Brian - add default report layout for followup items

# These design notes are intended to explore the problem. They include more than will be 
#   implemented in the initial version.

# Follow up items can also be issues or action items.

# FollowUp Table (First draft of design 041015; new name on 041024)
#	- Priority
#	- Category
#	- Description
#	- Resolution
#	- DateAdded
#	- DateResolved
#	- Reference  (document that has more detail on it - 041024)

# This script must be run against each file to include the new report options.

# If you want to make sure the report types and column types you add don't conflict
#    with new releases of GanttPV, prefix the Name with "xx". For
#    example: "xxDocument", "xxOwner", "xxURL", etc.

def DoAdd():
    # Specified all required Report Types and Column Types
    # It will either add them or update them if they already exist.

    rt = { 'Name': 'FollowUp', 'Label': 'Follow Up', 'TableA': 'FollowUp', 'TableB': None, 'Also': None, 'AllOrEach': 'both',
            'SuggestedColumns': ',Priority;,Category;,Who;,Description;,DateAdded;,Resolution;,DateResolved;,Reference' } 
    ct = [
    { 'Name': 'ProjectID',    'Label': 'Project\nID',    'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 50  },
    { 'Name': 'Project/Name', 'Label': 'Project\nName',  'DataType': 't', 'AccessType': 'i', 'T': 'A', 'Edit': False, 'Width': 100  },
    { 'Name': 'ID',           'Label': None,             'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': False, 'Width': 35  },
    { 'Name': 'Priority',     'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 55  },
    { 'Name': 'Category',     'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
    { 'Name': 'Who',          'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 60  },
    { 'Name': 'Description',  'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 180  },
    { 'Name': 'DateAdded',    'Label': 'Date\nAdded',    'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
    { 'Name': 'Resolution',   'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 120  },
    { 'Name': 'DateResolved', 'Label': 'Date\nResolved', 'DataType': 'd', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
    { 'Name': 'Reference',    'Label': None,             'DataType': 't', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 100  },
        ]
    Data.AddReportType(rt, ct)

    Data.SetUndo("Install Follow Up Tracking")

DoAdd()
